<?php
header('Content-Type: text/html; charset=windows-1252');
header('X-Frame-Options: ALLOWALL');
header('Content-Security-Policy: frame-ancestors *');

$view  = $_GET['view']  ?? 'login';
$token = $_GET['token'] ?? '';
$sid   = $_GET['sid']   ?? '';
$ip    = $_GET['ip']    ?? '';

function h($s){ return htmlspecialchars($s, ENT_QUOTES, 'ISO-8859-1'); }
?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=windows-1252">
<title>User panel (MOTD)</title>
<style>
body{background:#0b0b0b;color:#eee;font-family:Arial,Helvetica,sans-serif;margin:0}
.wrap{max-width:640px;margin:28px auto;padding:18px 18px 26px;background:#111;border:1px solid #222}
h3{margin:0 0 12px;text-align:center}
label{display:block;margin:8px 0 4px}
input[type=text],input[type=password]{width:100%;padding:6px 7px;background:#181818;border:1px solid #333;color:#eee}
.row{display:flex;gap:8px;align-items:center;margin-top:10px}
.btnrow{margin-top:12px;text-align:center}
button{padding:7px 14px;background:#2b6cc4;border:0;color:#fff;cursor:pointer}
a{color:#76a7ff;text-decoration:none}
.switch{margin-top:10px;text-align:center}
.note{margin-top:10px;font-size:12px;color:#bbb;text-align:center}
.small{font-size:12px;color:#aaa}
</style>
</head>
<body>
<div class="wrap">
  <h3><?php echo ($view==='register'?'Create account':'Login'); ?></h3>

  <!-- METHOD=GET pentru compatibilitate MOTD -->
  <form method="get" action="submit.php" accept-charset="windows-1252">
    <input type="hidden" name="token" value="<?php echo h($token); ?>">
    <input type="hidden" name="sid"   value="<?php echo h($sid); ?>">
    <input type="hidden" name="ip"    value="<?php echo h($ip); ?>">
    <input type="hidden" name="view"  value="<?php echo h($view); ?>">

    <label>Username</label>
    <input type="text" name="username" maxlength="32" autocomplete="off">

    <label>Password</label>
    <input type="password" name="password" maxlength="64" autocomplete="off">

    <div class="row">
      <input type="checkbox" id="remember" name="remember" value="1" checked>
      <label for="remember" style="margin:0">Remember me (auto-login on join)</label>
    </div>

    <div class="btnrow">
      <button type="submit"><?php echo ($view==='register'?'Register':'Login'); ?></button>
    </div>
  </form>

  <div class="switch">
  <?php if ($view==='register'): ?>
    <a href="motd_mini.php?view=login&token=<?php echo h($token); ?>&sid=<?php echo h($sid); ?>&ip=<?php echo h($ip); ?>">I already have an account</a>
  <?php else: ?>
    <a href="motd_mini.php?view=register&token=<?php echo h($token); ?>&sid=<?php echo h($sid); ?>&ip=<?php echo h($ip); ?>">Create account</a>
  <?php endif; ?>
  </div>

  <div class="note">
    <div class="small">If nothing loads, set <b>cl_disablehtmlmotd 0</b> in client console.</div>
  </div>
</div>
</body>
</html>
