<?php
require_once __DIR__ . '/util.php';

$token = $_GET['token'] ?? '';
$sid   = $_GET['sid'] ?? '';
$ip    = $_GET['ip'] ?? '';
$view  = $_GET['view'] ?? 'login';
$msg   = $_GET['msg'] ?? '';

if ($token !== '') {
  ensure_token_row($token, $sid, $ip, 'open');
}

function e($s){ return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }
?><!doctype html>
<html><head><meta charset="utf-8">
<title>User</title>
<style>
body{background:#0b0b0b;color:#eee;font-family:Arial;margin:0}
.wrap{max-width:420px;margin:12px auto;padding:10px;text-align:center}
h2{margin:8px 0}
a.btn, .btn{display:inline-block;padding:8px 12px;margin:6px;border:1px solid #888;text-decoration:none;color:#eee}
input{width:100%;padding:8px;margin:6px 0;background:#1b1b1b;border:1px solid #555;color:#eee}
small{color:#aaa}
.tabbar{margin-bottom:8px}
</style>
</head>
<body>
<div class="wrap">
  <div class="tabbar">
    <?php if($view==='login'): ?>
      <span class="btn">Login</span>
      <a class="btn" href="motd_auth.php?view=register&token=<?=e($token)?>&sid=<?=e($sid)?>&ip=<?=e($ip)?>">Register</a>
    <?php else: ?>
      <a class="btn" href="motd_auth.php?view=login&token=<?=e($token)?>&sid=<?=e($sid)?>&ip=<?=e($ip)?>">Login</a>
      <span class="btn">Register</span>
    <?php endif; ?>
  </div>

  <?php if($msg!==''): ?>
    <div style="margin:6px 0;color:#9cf;"><?=e($msg)?></div>
  <?php endif; ?>

  <?php if($view==='login'): ?>
    <form method="post" action="submit.php">
      <input type="hidden" name="action" value="login">
      <input type="hidden" name="token" value="<?=e($token)?>">
      <input type="hidden" name="sid" value="<?=e($sid)?>">
      <input type="hidden" name="ip" value="<?=e($ip)?>">
      <input name="user" placeholder="Username" autocomplete="username">
      <input name="pass" placeholder="Password" type="password" autocomplete="current-password">
      <label style="display:block;margin-top:6px">
        <input type="checkbox" name="remember" value="1"> Remember me
      </label>
      <button class="btn" type="submit">Login</button>
    </form>
    <small>Nu ai cont? <a class="btn" href="motd_auth.php?view=register&token=<?=e($token)?>&sid=<?=e($sid)?>&ip=<?=e($ip)?>">Creează unul</a></small>
  <?php else: ?>
    <form method="post" action="submit.php">
      <input type="hidden" name="action" value="register">
      <input type="hidden" name="token" value="<?=e($token)?>">
      <input type="hidden" name="sid" value="<?=e($sid)?>">
      <input type="hidden" name="ip" value="<?=e($ip)?>">
      <input name="user" placeholder="Username" autocomplete="username">
      <input name="pass" placeholder="Password" type="password" autocomplete="new-password">
      <button class="btn" type="submit">Create account</button>
    </form>
    <small><a class="btn" href="motd_auth.php?view=login&token=<?=e($token)?>&sid=<?=e($sid)?>&ip=<?=e($ip)?>">Înapoi la Login</a></small>
  <?php endif; ?>

  <div style="margin-top:8px"><small>SteamID: <?=e($sid)?> &nbsp; IP: <?=e($ip)?></small></div>
</div>
</body></html>
