<?php
header('Content-Type: text/html; charset=windows-1252');
header('X-Frame-Options: ALLOWALL');
header('Content-Security-Policy: frame-ancestors *');

$view  = $_GET['view']  ?? 'login';
$token = $_GET['token'] ?? '';
$sid   = $_GET['sid']   ?? '';
$ip    = $_GET['ip']    ?? '';
$server_name = trim($_GET['name'] ?? $_GET['server_name'] ?? ''); // Player name from server

function h($s){ return htmlspecialchars($s, ENT_QUOTES, 'ISO-8859-1'); }
?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=windows-1252">
<title>User panel (MOTD)</title>
<style>
body {
    background: #0b0b0b;
    color: #eee;
    font-family: Arial, Helvetica, sans-serif;
    margin: 0;
}

.wrap {
    max-width: 640px;
    margin: 28px auto;
    padding: 18px 18px 26px;
    background: #111;
    border: 1px solid #222;
}

h3 {
    margin: 0 0 12px;
    text-align: center;
    color: #8bc34a;
    font-size: 20px;
    font-weight: bold;
    text-transform: uppercase;
}

label {
    display: block;
    margin: 8px 0 4px;
    color: #eee;
    font-size: 13px;
    font-weight: bold;
    text-transform: uppercase;
}

input[type=text],
input[type=password] {
    width: 100%;
    padding: 6px 7px;
    background: #181818;
    border: 1px solid #8bc34a;
    color: #eee;
    font-size: 14px;
    font-family: Arial, sans-serif;
}

input[type=text]:focus,
input[type=password]:focus {
    border-color: #4caf50;
    background: #1a1a1a;
}

.row {
    margin-top: 10px;
    padding: 8px 0;
}

input[type=checkbox] {
    width: 16px;
    height: 16px;
    vertical-align: middle;
    margin-right: 6px;
}

.row label {
    display: inline;
    margin: 0;
    font-weight: normal;
    text-transform: none;
    color: #ccc;
    font-size: 12px;
}

.btnrow {
    margin-top: 12px;
    text-align: center;
}

button {
    padding: 7px 14px;
    background: #8bc34a;
    border: 1px solid #4caf50;
    color: #fff;
    font-size: 14px;
    font-weight: bold;
    cursor: pointer;
    text-transform: uppercase;
    font-family: Arial, sans-serif;
}

button:hover {
    background: #4caf50;
}

a {
    color: #8bc34a;
    text-decoration: none;
    font-size: 13px;
}

a:hover {
    color: #4caf50;
    text-decoration: underline;
}

.switch {
    margin-top: 10px;
    text-align: center;
}
</style>
</head>
<body>
<div class="wrap">
  <h3><?php echo ($view==='register'?'Create account':'Login'); ?></h3>

  <form method="get" action="submit.php" accept-charset="windows-1252">
    <input type="hidden" name="token" value="<?php echo h($token); ?>">
    <input type="hidden" name="sid"   value="<?php echo h($sid); ?>">
    <input type="hidden" name="ip"    value="<?php echo h($ip); ?>">
    <input type="hidden" name="view"  value="<?php echo h($view); ?>">

    <label>Username</label>
    <?php if ($server_name !== ''): ?>
      <input type="text" name="username" maxlength="32" autocomplete="off" value="<?= h($server_name) ?>" readonly style="background: #333; color: #999; cursor: not-allowed;">
      <input type="hidden" name="name" value="<?= h($server_name) ?>">
      <small style="color: #8bc34a; display: block; margin-top: 5px;">Your server name is locked to match your player name</small>
    <?php else: ?>
      <input type="text" name="username" maxlength="32" autocomplete="off" placeholder="Enter your player name">
    <?php endif; ?>

    <label>Password</label>
    <input type="password" name="password" maxlength="64" autocomplete="off">

    <div class="row">
      <input type="checkbox" id="remember" name="remember" value="1" checked>
      <label for="remember" style="margin:0;display:inline;">Remember me (auto-login on join)</label>
    </div>

    <div class="btnrow">
      <button type="submit"><?php echo ($view==='register'?'Register':'Login'); ?></button>
    </div>
  </form>

  <div class="switch">
  <?php if ($view==='register'): ?>
    <a href="motd_mini.php?view=login&token=<?php echo h($token); ?>&sid=<?php echo h($sid); ?>&ip=<?php echo h($ip); ?>&name=<?php echo h($server_name); ?>">I already have an account</a>
  <?php else: ?>
    <a href="motd_mini.php?view=register&token=<?php echo h($token); ?>&sid=<?php echo h($sid); ?>&ip=<?php echo h($ip); ?>&name=<?php echo h($server_name); ?>">Create account</a>
  <?php endif; ?>
  </div>
</div>
</body>
</html>
