<?php
header('Content-Type: text/plain; charset=utf-8');
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/util.php';

try {
    $pdo = db();
    
    // Get all unique skin names from database
    $stmt = $pdo->query("SELECT DISTINCT skin_name FROM counter_strike_user_skins ORDER BY skin_name ASC");
    $skins = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    echo "=== SKINS IN DATABASE ===\n";
    echo "Total unique skins: " . count($skins) . "\n\n";
    
    foreach ($skins as $skin) {
        echo "Skin: '" . $skin . "' (length: " . strlen($skin) . ")\n";
        // Show hex representation to see hidden characters
        $hex = bin2hex($skin);
        echo "  Hex: " . $hex . "\n";
        echo "  Trimmed: '" . trim($skin) . "'\n";
        echo "\n";
    }
    
    // Also show for a specific user if provided
    if (isset($_GET['username'])) {
        $username = trim($_GET['username']);
        echo "\n=== SKINS FOR USER: $username ===\n";
        
        $stmt = $pdo->prepare("SELECT id FROM counter_strike_users WHERE username = ? LIMIT 1");
        $stmt->execute([$username]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($user) {
            $user_id = intval($user['id']);
            $stmt = $pdo->prepare("SELECT skin_name FROM counter_strike_user_skins WHERE user_id = ? ORDER BY skin_name ASC");
            $stmt->execute([$user_id]);
            $userSkins = $stmt->fetchAll(PDO::FETCH_COLUMN);
            
            echo "User ID: $user_id\n";
            echo "Total skins: " . count($userSkins) . "\n\n";
            
            foreach ($userSkins as $skin) {
                echo "  - '" . $skin . "'\n";
            }
        } else {
            echo "User not found!\n";
        }
    }
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}

