<?php
/**
 * Update local skin file for a specific user
 * This ensures plugin can read skins even if HTTP fails
 * 
 * Usage: update_user_skins_file.php?username=PlayerName
 * Or call from shop_skins.php after purchase
 */

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/util.php';

function update_user_skins_file($username) {
    try {
        $pdo = db();
        
        // Get user ID
        $stmt = $pdo->prepare("SELECT id FROM counter_strike_users WHERE username = ? LIMIT 1");
        $stmt->execute([$username]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$user) {
            return ['success' => false, 'error' => 'User not found'];
        }
        
        $user_id = intval($user['id']);
        
        // Get all user's skins from database
        $stmt = $pdo->prepare("SELECT skin_name FROM counter_strike_user_skins WHERE user_id = ? ORDER BY skin_name ASC");
        $stmt->execute([$user_id]);
        $all_user_skins = $stmt->fetchAll(PDO::FETCH_COLUMN);
        
        // Create/update local file
        $local_file = __DIR__ . '/user_skins_' . $username . '.txt';
        $fp = fopen($local_file, 'w');
        if (!$fp) {
            return ['success' => false, 'error' => 'Cannot create file: ' . $local_file];
        }
        
        fwrite($fp, "OK\n");
        foreach ($all_user_skins as $skin_name) {
            fwrite($fp, $skin_name . "\n");
        }
        fclose($fp);
        
        return [
            'success' => true, 
            'username' => $username,
            'skin_count' => count($all_user_skins),
            'file' => $local_file
        ];
    } catch (Exception $e) {
        return ['success' => false, 'error' => $e->getMessage()];
    }
}

// If called via web (for testing/manual update)
if (php_sapi_name() !== 'cli' && isset($_GET['username'])) {
    header('Content-Type: text/plain; charset=utf-8');
    $username = trim($_GET['username'] ?? '');
    if (empty($username)) {
        echo "ERROR: No username provided\n";
        exit;
    }
    
    $result = update_user_skins_file($username);
    if ($result['success']) {
        echo "OK\n";
        echo "Updated file for user: " . $result['username'] . "\n";
        echo "Skin count: " . $result['skin_count'] . "\n";
        echo "File: " . $result['file'] . "\n";
    } else {
        echo "ERROR: " . $result['error'] . "\n";
    }
}

