<?php
/**
 * Update local skin files for ALL users
 * Run this once to create/update files for all existing users
 * 
 * Usage: Access via browser: update_all_user_files.php
 */

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/util.php';
require_once __DIR__ . '/update_user_skins_file.php';

header('Content-Type: text/plain; charset=utf-8');

echo "=== Updating local skin files for all users ===\n\n";

try {
    $pdo = db();
    
    // Get all users
    $stmt = $pdo->query("SELECT DISTINCT username FROM counter_strike_users ORDER BY username ASC");
    $users = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    echo "Found " . count($users) . " users\n\n";
    
    $success_count = 0;
    $error_count = 0;
    
    foreach ($users as $username) {
        $result = update_user_skins_file($username);
        if ($result['success']) {
            echo "✓ " . $username . " - " . $result['skin_count'] . " skins\n";
            $success_count++;
        } else {
            echo "✗ " . $username . " - ERROR: " . $result['error'] . "\n";
            $error_count++;
        }
    }
    
    echo "\n=== Summary ===\n";
    echo "Success: $success_count\n";
    echo "Errors: $error_count\n";
    echo "Total: " . count($users) . "\n";
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}

