<?php
header('Content-Type: text/html; charset=utf-8');
header('X-Frame-Options: ALLOWALL');
header('Content-Security-Policy: frame-ancestors *');

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/util.php';

function h($s){ return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }

// Table name following the same pattern as other CS tables
define('PLUGINS_TABLE', 'counter_strike_plugin_presentations');

// Get all active plugins
$plugins = [];
try {
    $pdo = db();
    $stmt = $pdo->query("SELECT * FROM " . PLUGINS_TABLE . " WHERE active = 1 ORDER BY created_at DESC");
    $plugins = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    // Table might not exist yet
}
?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title>Plugins</title>
<style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

html, body {
    height: auto;
    min-height: 100%;
    overflow-x: hidden;
    overflow-y: auto;
}

body {
    background: #0b0b0b;
    color: #eee;
    font-family: Arial, Helvetica, sans-serif;
    margin: 0;
    padding: 0;
}

body::-webkit-scrollbar {
    width: 12px;
}

body::-webkit-scrollbar-track {
    background: #0b0b0b;
}

body::-webkit-scrollbar-thumb {
    background: #8bc34a;
    border: 2px solid #4caf50;
}

body::-webkit-scrollbar-thumb:hover {
    background: #4caf50;
}

.wrap {
    max-width: 1200px;
    margin: 0 auto;
    padding: 20px;
    background: #111;
    border: 1px solid #222;
    min-height: 100%;
}

h3 {
    margin: 0 0 30px;
    text-align: center;
    color: #8bc34a;
    font-size: 28px;
    font-weight: bold;
    text-transform: uppercase;
}

.plugins-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 20px;
    width: 100%;
}

.plugin-card {
    background: #181818;
    border: 2px solid #8bc34a;
    padding: 15px;
    text-align: center;
    transition: all 0.3s ease;
    cursor: pointer;
    text-decoration: none;
    color: inherit;
    display: block;
}

.plugin-card:hover {
    border-color: #4caf50;
    transform: translateY(-5px);
    box-shadow: 0 6px 12px rgba(139, 195, 74, 0.3);
}

.plugin-card img {
    width: 100%;
    height: 200px;
    object-fit: cover;
    background: #0b0b0b;
    margin-bottom: 15px;
    border: 1px solid #333;
}

.plugin-card-name {
    color: #8bc34a;
    font-weight: bold;
    font-size: 16px;
    margin-bottom: 10px;
    min-height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.plugin-card-desc {
    color: #ccc;
    font-size: 13px;
    line-height: 1.4;
    overflow: hidden;
    text-overflow: ellipsis;
    display: -webkit-box;
    -webkit-line-clamp: 3;
    -webkit-box-orient: vertical;
}

@media (max-width: 992px) {
    .plugins-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}

@media (max-width: 600px) {
    .plugins-grid {
        grid-template-columns: 1fr;
    }
}

.empty-state {
    text-align: center;
    color: #666;
    padding: 60px 20px;
    grid-column: 1 / -1;
}
</style>
</head>
<body>
<div class="wrap">
  <h3>Plugins</h3>
  
  <div class="plugins-grid">
    <?php if (empty($plugins)): ?>
      <div class="empty-state">
        <p style="font-size: 18px; margin-bottom: 10px;">No plugins available yet.</p>
        <p style="font-size: 14px; color: #999;">Check back later for new plugins!</p>
      </div>
    <?php else: ?>
      <?php foreach ($plugins as $plugin): ?>
        <a href="plugin_detail.php?id=<?= $plugin['id'] ?>" class="plugin-card">
          <img src="<?= h($plugin['image_url']) ?: 'data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' width=\'300\' height=\'200\'%3E%3Crect fill=\'%23333\' width=\'300\' height=\'200\'/%3E%3Ctext x=\'50%25\' y=\'50%25\' text-anchor=\'middle\' dy=\'.3em\' fill=\'%23666\' font-size=\'14\'%3ENo Image%3C/text%3E%3C/svg%3E' ?>" 
               alt="<?= h($plugin['name']) ?>"
               onerror="this.src='data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' width=\'300\' height=\'200\'%3E%3Crect fill=\'%23333\' width=\'300\' height=\'200\'/%3E%3Ctext x=\'50%25\' y=\'50%25\' text-anchor=\'middle\' dy=\'.3em\' fill=\'%23666\' font-size=\'14\'%3ENo Image%3C/text%3E%3C/svg%3E'">
          <div class="plugin-card-name"><?= h($plugin['name']) ?></div>
          <?php if ($plugin['description']): ?>
            <div class="plugin-card-desc"><?= h($plugin['description']) ?></div>
          <?php endif; ?>
        </a>
      <?php endforeach; ?>
    <?php endif; ?>
  </div>
</div>
</body>
</html>

