<?php
header('Content-Type: text/plain; charset=windows-1252');
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/util.php';

function h($s){ return htmlspecialchars($s, ENT_QUOTES, 'ISO-8859-1'); }

// Get username from GET parameter
$username = trim($_GET['username'] ?? '');

if (empty($username)) {
    echo "ERROR: No username provided\n";
    exit;
}

try {
    $pdo = db();
    
    // Get user ID
    $stmt = $pdo->prepare("SELECT id FROM counter_strike_users WHERE username = ? LIMIT 1");
    $stmt->execute([$username]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$user) {
        echo "ERROR: User not found\n";
        exit;
    }
    
    $user_id = intval($user['id']);
    
    // Get user's purchased skins
    // New format: skin_name contains "weapon_key|skin_key" (e.g., "m4a1|musica")
    // Old format: skin_name contains display name (e.g., "M4A1 Muzica") - backward compatibility
    $stmt = $pdo->prepare("SELECT skin_name FROM counter_strike_user_skins WHERE user_id = ? ORDER BY skin_name ASC");
    $stmt->execute([$user_id]);
    $skins = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    // Output format: OK\nweapon_key|skin_key\nweapon_key|skin_key...
    // or OK\nskin_name\nskin_name... (fallback for old format)
    echo "OK\n";
    foreach ($skins as $skin) {
        echo h($skin) . "\n";
    }
    
    // Note: Plugin will create/update local file automatically on CS server when it receives this response
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}

