<?php
/**
 * Quick script to get skins for a user from DB
 * Usage: php get_skins_for_user.php "IM QUATRO"
 */

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/util.php';

$username = isset($argv[1]) ? trim($argv[1]) : '';

if (empty($username)) {
    echo "Usage: php get_skins_for_user.php \"username\"\n";
    echo "Example: php get_skins_for_user.php \"IM QUATRO\"\n";
    exit(1);
}

try {
    $pdo = db();
    
    // Get user ID
    $stmt = $pdo->prepare("SELECT id FROM counter_strike_users WHERE username = ? LIMIT 1");
    $stmt->execute([$username]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$user) {
        echo "ERROR: User '$username' not found in database\n";
        exit(1);
    }
    
    $user_id = intval($user['id']);
    echo "User ID: $user_id\n\n";
    
    // Get user's skins from database
    $stmt = $pdo->prepare("SELECT skin_name FROM counter_strike_user_skins WHERE user_id = ? ORDER BY skin_name ASC");
    $stmt->execute([$user_id]);
    $skins = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    echo "=== SKINS FOR USER: $username ===\n";
    echo "Total skins: " . count($skins) . "\n\n";
    
    if (count($skins) == 0) {
        echo "No skins found in database.\n";
        exit(0);
    }
    
    echo "Skin names (copy these to file):\n";
    echo "OK\n";
    foreach ($skins as $skin) {
        echo trim($skin) . "\n";
    }
    
    echo "\n=== FILE CONTENT ===\n";
    echo "Copy this to: addons/amxmodx/configs/user_skins_$username.txt\n\n";
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    exit(1);
}

