<?php
header('Content-Type: text/plain; charset=windows-1252');
require_once __DIR__ . '/config.php';

// Get parameters - prioritize username/name for autologin
$username = trim($_GET['username'] ?? $_GET['name'] ?? '');
$sid = $_GET['sid'] ?? '';
$ip  = $_GET['ip']  ?? '';

// Autologin now works ONLY by username (as requested)
// This ensures that if player name on server matches registered username EXACTLY, they are logged in
// If name doesn't match, autologin will FAIL (no fallback to SteamID or IP)
if ($username === '') { 
    echo "FAIL noname\n"; 
    exit; 
}

// Decode URL-encoded username (handles + for spaces and %XX encoding)
$username = urldecode($username);
$username = trim($username);

if ($username === '') { 
    echo "FAIL noname\n"; 
    exit; 
}

$db = @mysqli_connect(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if (!$db){ echo "FAIL db\n"; exit; }
mysqli_set_charset($db,'utf8mb4');

$usernameE = mysqli_real_escape_string($db,$username);

// DEBUG: Log the request (remove after testing)
$debug_msg = "[".date('Y-m-d H:i:s')."] Request - Username: '{$username}' (length: ".strlen($username).") | SID: '{$sid}' | IP: '{$ip}'\n";
@file_put_contents(__DIR__.'/auto_debug.log', $debug_msg, FILE_APPEND);

// Check autologin ONLY by username (name must match EXACTLY, case-sensitive)
// NO fallback to SteamID or IP - only exact username match works
$q = "SELECT id, username FROM counter_strike_users WHERE username='$usernameE' AND auto_login=1 LIMIT 1";

$r = mysqli_query($db,$q);
if ($r && ($row=mysqli_fetch_assoc($r))) {
    // Double-check: verify the username matches exactly (case-sensitive)
    // This prevents any edge cases where partial matches might occur
    $db_username = $row['username'];
    $db_username_len = strlen($db_username);
    $req_username_len = strlen($username);
    
    $debug_match = "[".date('Y-m-d H:i:s')."] Found user - DB: '{$db_username}' (len: {$db_username_len}) | Request: '{$username}' (len: {$req_username_len})\n";
    @file_put_contents(__DIR__.'/auto_debug.log', $debug_match, FILE_APPEND);
    
    if ($row['username'] === $username) {
        // Update last_login and also update steamid/ip if provided (for reference, but not used for autologin)
        $update_q = "UPDATE counter_strike_users SET last_login=CURRENT_TIMESTAMP";
        if ($sid !== '') {
            $sidE = mysqli_real_escape_string($db,$sid);
            $update_q .= ", steamid='$sidE'";
        }
        if ($ip !== '') {
            $ipE = mysqli_real_escape_string($db,$ip);
            $update_q .= ", ip='$ipE'";
        }
        $update_q .= " WHERE id=".(int)$row['id'];
        mysqli_query($db,$update_q);
        @file_put_contents(__DIR__.'/auto_debug.log', "[".date('Y-m-d H:i:s')."] OK - User ID: {$row['id']}, Username: '{$row['username']}'\n", FILE_APPEND);
        echo "OK ".$row['username']."\n";
    } else {
        // Username doesn't match exactly - FAIL autologin
        $debug_nomatch = "[".date('Y-m-d H:i:s')."] FAIL nomatch - DB: '{$db_username}' (len: {$db_username_len}) != Request: '{$username}' (len: {$req_username_len})\n";
        @file_put_contents(__DIR__.'/auto_debug.log', $debug_nomatch, FILE_APPEND);
        echo "FAIL nomatch\n";
    }
} else {
    // No user found with this username and auto_login=1 - FAIL autologin
    // Also check if user exists but doesn't have auto_login=1
    $q_check = "SELECT id, username, auto_login FROM counter_strike_users WHERE username='$usernameE' LIMIT 1";
    $r_check = mysqli_query($db,$q_check);
    if ($r_check && ($row_check=mysqli_fetch_assoc($r_check))) {
        $debug_noauto = "[".date('Y-m-d H:i:s')."] FAIL - User '{$username}' exists (ID: {$row_check['id']}) but auto_login={$row_check['auto_login']} (not 1)\n";
        @file_put_contents(__DIR__.'/auto_debug.log', $debug_noauto, FILE_APPEND);
    } else {
        $debug_notfound = "[".date('Y-m-d H:i:s')."] FAIL - No user found with username '{$username}' at all\n";
        @file_put_contents(__DIR__.'/auto_debug.log', $debug_notfound, FILE_APPEND);
    }
    echo "FAIL\n";
}
