<?php
// Admin settings handler (AJAX endpoint)
header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/util.php';

// Start session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check if logged in
$is_logged_in = isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;

if (!$is_logged_in) {
    echo json_encode(['success' => false, 'error' => 'Not logged in']);
    exit;
}

// Get or set setting
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        $pdo = db();
        
        // Create settings table if it doesn't exist
        $pdo->exec("CREATE TABLE IF NOT EXISTS counter_strike_settings (
            setting_key VARCHAR(100) PRIMARY KEY,
            setting_value TEXT,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        )");
        
        $key = $_GET['key'] ?? 'admin_registration_enabled';
        $stmt = $pdo->prepare("SELECT setting_value FROM counter_strike_settings WHERE setting_key = ?");
        $stmt->execute([$key]);
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        
        $value = $result ? $result['setting_value'] : '1'; // Default: enabled
        echo json_encode(['success' => true, 'value' => $value]);
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'error' => $e->getMessage()]);
    }
} elseif ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $pdo = db();
        
        // Create settings table if it doesn't exist
        $pdo->exec("CREATE TABLE IF NOT EXISTS counter_strike_settings (
            setting_key VARCHAR(100) PRIMARY KEY,
            setting_value TEXT,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        )");
        
        $key = $_POST['key'] ?? 'admin_registration_enabled';
        $value = $_POST['value'] ?? '1';
        
        $stmt = $pdo->prepare("INSERT INTO counter_strike_settings (setting_key, setting_value) 
                              VALUES (?, ?) 
                              ON DUPLICATE KEY UPDATE setting_value = ?");
        $stmt->execute([$key, $value, $value]);
        
        echo json_encode(['success' => true, 'message' => 'Setting updated']);
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'error' => $e->getMessage()]);
    }
}

