<?php
// Start session first
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Load config and util first
require_once dirname(__FILE__) . '/config.php';
require_once dirname(__FILE__) . '/util.php';

header('Content-Type: text/html; charset=windows-1252');
header('X-Frame-Options: ALLOWALL');
header('Content-Security-Policy: frame-ancestors *');

function h($s){ return htmlspecialchars($s, ENT_QUOTES, 'ISO-8859-1'); }

$success_msg = '';
$error_msg = '';

// Check if registration is enabled
$registration_enabled = true;
try {
    $pdo = db();
    
    // Create settings table if it doesn't exist
    $pdo->exec("CREATE TABLE IF NOT EXISTS counter_strike_settings (
        setting_key VARCHAR(100) PRIMARY KEY,
        setting_value TEXT,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )");
    
    $stmt = $pdo->prepare("SELECT setting_value FROM counter_strike_settings WHERE setting_key = 'admin_registration_enabled'");
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($result && $result['setting_value'] === '0') {
        $registration_enabled = false;
    }
} catch (Exception $e) {
    // If error, allow registration (default behavior)
}

// Handle registration
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'register') {
    if (!$registration_enabled) {
        $error_msg = 'New admin registrations are currently disabled. Please contact an existing administrator.';
    } else {
        $email = trim($_POST['email'] ?? '');
        $pass = $_POST['password'] ?? '';
        $pass_confirm = $_POST['password_confirm'] ?? '';
        
        if (empty($email) || empty($pass)) {
            $error_msg = 'Please fill all fields';
        } elseif ($pass !== $pass_confirm) {
            $error_msg = 'Passwords do not match';
        } elseif (strlen($pass) < 6) {
            $error_msg = 'Password must be at least 6 characters';
        } else {
            try {
                $pdo = db();
                
                // Check if email already exists
                $stmt = $pdo->prepare("SELECT id FROM counter_strike_admins WHERE email = ?");
                $stmt->execute([$email]);
                if ($stmt->fetch()) {
                    $error_msg = 'This email is already registered';
                } else {
                    // Create admin account
                    $password_hash = password_hash($pass, PASSWORD_DEFAULT);
                    $stmt = $pdo->prepare("INSERT INTO counter_strike_admins (email, password_hash) VALUES (?, ?)");
                    $stmt->execute([$email, $password_hash]);
                    $success_msg = 'Admin account created successfully! You can now login.';
                }
            } catch (Exception $e) {
                $error_msg = 'Error: ' . $e->getMessage();
            }
        }
    }
}
?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=windows-1252">
<title>Admin Registration</title>
<style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

html {
    scroll-behavior: smooth;
}

body {
    background: #0b0b0b;
    color: #eee;
    font-family: Arial, Helvetica, sans-serif;
    margin: 0;
    padding: 20px;
}

.wrap {
    max-width: 500px;
    margin: 50px auto;
    padding: 30px;
    background: #111;
    border: 1px solid #222;
}

h3 {
    margin: 0 0 25px;
    text-align: center;
    color: #8bc34a;
    font-size: 24px;
    font-weight: bold;
    text-transform: uppercase;
}

.register-form {
    padding: 20px;
    background: #181818;
    border: 1px solid #333;
}

label {
    display: block;
    margin: 15px 0 5px;
    color: #ccc;
    font-size: 14px;
    font-weight: bold;
}

input[type="email"],
input[type="password"] {
    width: 100%;
    padding: 12px;
    background: #0b0b0b;
    border: 2px solid #8bc34a;
    color: #eee;
    font-size: 14px;
    font-family: Arial, sans-serif;
}

input:focus {
    border-color: #4caf50;
    outline: none;
}

button {
    padding: 12px 24px;
    background: #8bc34a;
    border: 2px solid #4caf50;
    color: #fff;
    font-size: 14px;
    font-weight: bold;
    cursor: pointer;
    text-transform: uppercase;
    margin-top: 20px;
    width: 100%;
}

button:hover {
    background: #4caf50;
}

.msg {
    padding: 12px;
    margin: 15px 0;
    border-radius: 4px;
    text-align: center;
    font-weight: bold;
}

.msg.success {
    background: rgba(139, 195, 74, 0.2);
    border: 1px solid #8bc34a;
    color: #8bc34a;
}

.msg.error {
    background: rgba(244, 67, 54, 0.2);
    border: 1px solid #f44336;
    color: #f44336;
}

.login-link {
    display: block;
    text-align: center;
    margin-top: 20px;
    color: #8bc34a;
    text-decoration: none;
    font-size: 14px;
}

.login-link:hover {
    color: #4caf50;
    text-decoration: underline;
}
</style>
</head>
<body>
<div class="wrap">
  <h3>Admin Registration</h3>
  
  <div class="register-form">
    <?php if (!$registration_enabled): ?>
      <div class="msg error">New admin registrations are currently disabled. Please contact an existing administrator to create an account.</div>
      <a href="admin_add_skin.php" class="login-link">Go to Login</a>
    <?php elseif ($success_msg): ?>
      <div class="msg success"><?= h($success_msg) ?></div>
      <a href="admin_add_skin.php" class="login-link">Go to Login</a>
    <?php else: ?>
      <?php if ($error_msg): ?>
        <div class="msg error"><?= h($error_msg) ?></div>
      <?php endif; ?>
      
      <form method="post">
        <input type="hidden" name="action" value="register">
        <label>Email:</label>
        <input type="email" name="email" required autocomplete="email" placeholder="your@email.com">
        <label>Password:</label>
        <input type="password" name="password" required autocomplete="new-password" placeholder="Minimum 6 characters">
        <label>Confirm Password:</label>
        <input type="password" name="password_confirm" required autocomplete="new-password" placeholder="Repeat password">
        <button type="submit">Register</button>
      </form>
      
      <a href="admin_add_skin.php" class="login-link">Already have an account? Login</a>
    <?php endif; ?>
  </div>
</div>
</body>
</html>

